/*
 * Copyright James Morse Y2K+1
 * This is GPLed software 
 * please read COPYING
 *
 */

#include <curses.h>
#include <math.h>
#include <stdlib.h>
#include "bug5.h"

int main (int argc, char *argv[])
{
	int temp;
	int ch = 0;
	int dm = 1;
	int fg = 0;
	char *sbis = "xx \0";
	char *sbmsg = "x 12345 vcegzb hjklw fstpn \0";
	WINDOW *stat_bar;
	int pad_col = 0;
	int pad_row = 0;
	char msg[80];
	int pf = 0;
	int cpuwait = 1; // this is to slow down the bugs ... higher is slower
	
	// parse command line
	world_size = 2;
	roughness = 150;
	grid_size = 4;
	
	if (argc <= 7)
	{
		for (temp = 1; temp < argc; temp++)
		{
			if (strcmp (argv[temp], "-s") == 0)
			{
				world_size = atof (argv[++temp]);
				if ((world_size < .25) || (world_size > 30))
				{
					fprintf (stderr, "try -s [.25-30]\n");
					exit (3);
				}
			}
			else if (strcmp (argv[temp], "-r") == 0)
			{
				roughness = atoi (argv[++temp]);
				if ((roughness < 1) || (roughness > 1000))
				{
					fprintf (stderr, "try -r [1-1000]\n");
					exit (5);
				}
			}
			else if (strcmp (argv[temp], "-g") == 0)
			{
				grid_size = atoi (argv[++temp]);
				if ((grid_size < 2) || (grid_size > 8))
				{
					fprintf (stderr, "try -g [2-8]\n");
					exit (6);
				}
			}
			else 
			{
				fprintf (stderr, "bad args\n");
				exit (4);
			}
		}
	}
	else
	{
		fprintf (stderr, "I'm confused too many args\n");
		exit (2);
	}
	
	init ();
	stat_bar = newwin (1, COLS, LINES-1, 0);

	first = bugs;
	sb = bugs;
	hf = bugs;
	hg = bugs;
	old = bugs;
	hk = bugs;
	
	// while bugs do meet taget ... 1000 gen ... 200 food ... ect
	// 1 = just run for ever no target
	while (1)
	{
		// first bug in loop better check out some stuff
		if (bugs == first)
		{
			// be nice to the processor
			if (cpuwait)
				usleep (cpuwait);

			// refresh the display
			if (dm)
				prefresh (world_pad, pad_row, pad_col, 0, 0, LINES - 2, COLS - 1);
			else
			{
				stat ();
				wrefresh (stdscr);
			}
	
			// show status bar
			mvwprintw (stat_bar, 0, 0, "%s  %s  ", sbmsg, sbis);
			wrefresh (stat_bar);
	
			// next "gene"
			fg = ++fg % FOOD_GROW;

			// user did what ???
			if (kb_hit () || (ch == 'n') || (ch == 'N'))
			{
				// are we paused???
				do
				{
					if (kb_hit ())
						ch = read_kb ();
					else if ((ch = 'n') || (ch == 'N'))
						ch = '\0';
						
					switch (ch)
					{
						case 'z': // edit race & DNA
						case 'Z':
							dm = !dm;
							break;
						case 'e': // edit race & DNA
						case 'E':
							edit (sb);
							break;
						case 'b': // view contents of sb->things[]
						case 'B':
							view_t (sb);
							break;
						case 'c': // show sb counts
						case 'C':
							sprintf (msg, "R=%c G=%i A=%i Fd=%i S=%i Fv=%i F@=%i ", sb->race, sb->gen, sb->age, sb->food, sb->size, sb->fov, sb->things[FOOD3]);
							dopopup (msg, 3);
							break;
						case 'w': // show sb counts
						case 'W':
							sprintf (msg, "A=%i W=%.2f M=%.2f S=%.2f", (world_col * world_row), ((float)(100 * wtr_c) / (float)(world_col * world_row)), ((float)(100 * mnt_c) / (float)(world_col * world_row)), ((float)(100 * ((world_col * world_row) - wtr_c - mnt_c)) / (float)(world_col * world_row)));
							dopopup (msg, 5);
							break;
						case 'v': // view pos of sb
						case 'V':
							sprintf (msg, "x=%i  y=%i  v=%i", sb->xpos, sb->ypos, sb->vector);
							dopopup (msg, 2);
							break;
						case '1': // make sb = next
							sbis = "xx \0";
							sb = sb->next;
							break;
						case '2': // make sb = high food
							sbis = "hf \0";
							sb = hf;
							break;
						case '3': // make sb = high gen
							sbis = "hg \0";
							sb = hg;
							break;
						case '4': // make sb = oldest
							sbis = "old\0";
							sb = old;
							break;
						case '5': // make sb = highest kills
							sbis = "hk \0";
							sb = hk;
							break;
						case 'g': // snap screen to sb
						case 'G':
							pad_row = sb->ypos - ((LINES - 1) / 2);
							if (pad_row < 0)
								pad_row = 0;
							if (pad_row > (world_row - LINES + 1))
								pad_row = world_row - LINES + 1;
							pad_col = sb->xpos - (COLS / 2);
							if (pad_col < 0)
								pad_col = 0;
							if(pad_col > (world_col - COLS))
								pad_col = world_col - COLS;
							break;
						case 'h': // move screen left
						case 'H':
							if (pad_col > 0)
								pad_col--;
							break;
						case 'j': // move screen down
						case 'J':
							if (pad_row < (world_row - LINES + 1))
								pad_row++;
							break;
						case 'k': // move screen up
						case 'K':
							if (pad_row > 0)	
								pad_row--;
							break;
						case 'l': // move screen right
						case 'L':
							if (pad_col < (world_col - COLS))
								pad_col++;
							break;
						case 'x': // exit	
						case 'X':
							stop ();
							break;
						case 'f': // faster
						case 'F':
							if (cpuwait <= 1)
								cpuwait = 0;
							else
								cpuwait /= 2;
							sprintf (msg,"speed=%i", cpuwait);
							dopopup (msg, 1);
							pf = 0;
							break;
						case 's': // slower
						case 'S':
							if (cpuwait)
								cpuwait *= 2;
							else
								cpuwait = 1;
							sprintf (msg, "speed=%i", cpuwait);
							dopopup (msg, 1);
							pf = 0;
							break;					
						case 't': // turbo fast as can go
						case 'T':
							cpuwait = 0;
							sprintf (msg, "speed=%i", cpuwait);
							dopopup (msg, 1);
							pf = 0;
							break;
						case 'p': // pause
						case 'P':
							dopopup ("Pause", 1);
							ch = '\0';
							pf = !pf;
							break;
						case '\0': // update when paused
							// refresh the display
							if (dm)
								prefresh (world_pad, pad_row, pad_col, 0, 0, LINES - 2, COLS - 1);
							else
							{
								stat ();
								wrefresh (stdscr);
							}
							// show status bar
							mvwprintw (stat_bar, 0, 0, "%s  %s  ", sbmsg, sbis);
							wrefresh (stat_bar);
							usleep (100000);
							break;	
						case 'n': // single step
						case 'N':
							dopopup ("Single step", 1);
							pf = !0;
							break;
						default: // user hit unused key
							dopopup ("bad key", 1);
							break;
					} // clsose swtich()
				} // pasued???
				while (pf && (ch != 'n') && (ch != 'N'));
			} // done with user
		} // end first bug
		
		// start of gorwth cycle check some other stuff
		if (fg == 0)
		{
			// grow some food
			if (bugs == first)
				growfood ();
		
			// get older
			bugs->age++;
						
			// did bug eat lots???
			if (bugs->food >= SPLIT_LVL)
				mate ();
				
			// keep track of special bugs
			if (bugs->food > hf->food)
				hf = bugs;

			if (bugs->gen > hg->gen)
				hg = bugs;

			if (bugs->age > old->age)
				old = bugs;

			if (bugs->things[FOOD3] < hk->things[FOOD3])
				hk = bugs;

			// did bug starve to death ???
			if (bugs->food <= 0)
			{
				if (sb == bugs)
				sbis = "xx \0";
				die (bugs);
			}	
		} // end of other stuff
			
		bugs = bugs->next;
		mvwprintw (world_pad, bugs->ypos, bugs->xpos, "%c", SPACE);

		// what is bug doing???
		switch (look ())
		{
			case WAIT: // do nothing
				bugs->food -= WAIT_F;
				break;
			case RIGHT: // turn left
				bugs->food -= TURN_F;
				bugs->vector = (bugs->vector + 1) % 4;        
				break;
			case LEFT: // turn right
				bugs->food -= TURN_F;
				bugs->vector = (bugs->vector + 3) % 4;
				break;
			case FORWARD: // move ahead
				bugs->food -= MOVE_F;
				switch (bugs->vector)
				{
					case 0:	// screen up
						bugs->ypos = (--bugs->ypos + world_row) % world_row;
						break;
					case 1: // screen right
						bugs->xpos = (++bugs->xpos) % world_col;
						break;
					case 2: //screen down
						bugs->ypos = (++bugs->ypos) % world_row;
						break;
					case 3: // screen left
						bugs->xpos = (--bugs->xpos + world_col) % world_col;
						break;                                          
					default:
						fprintf (stderr, "default in main inner bugs->vector is bad\n");
						break;
				}
				break;
			default:
				fprintf (stderr, "default in main look returned a bad value\n");
				break;
		} // bug done
		if (bugs == sb) wattron (world_pad, WA_STANDOUT);
		mvwprintw (world_pad, bugs->ypos, bugs->xpos, "%c", bugs->race);
		if (bugs == sb) wattroff (world_pad, WA_STANDOUT);
	} // exit from main while loop ... 
	dopopup ("exited from main while loop", 3);
	stat ();
	stop ();
	
	//this is pointless ... never gets here
	return;
}
