#include <curses.h>
#include <math.h>
#include "bug4.h"

int is_bug(char temp)
{
	if (temp >= L_RACE && temp <= H_RACE)
		return(1);
	else
		return(0);
}

int is_pass(char temp)
{
	if ((temp == WTR)||(temp == MNT)||(is_bug(temp)))
		return(0);
	else
		return(1);
}

float motivate(char temp, int depth)
{
	float motivation = 0;

	if ((temp == bugs->food_type)&&(bugs->food < MATE_LVL))
		motivation = (float)FOOD_VAL / (float)depth;

	else if ((temp == bugs->food_type)&&(bugs->food > MATE_LVL))
		motivation = (float)FOOD_VAL / (float)(depth * 2);

	else if ((temp == bugs->race)&&(bugs->food > MATE_LVL))
		motivation = (float)(bugs->food - MATE_LVL) / (float)depth;

	return(motivation);
}

// recursive fractal look ...
float look_b(int depth, int vec, int yo, int xo)
{
	float weight = 0;
	int val;
	char temp[3];
	
	switch(bugs->vector)
	{
		case 0:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row - yo) % world_row,(bugs->xpos + world_col + xo) % world_col,temp,1);
			break;
		case 1:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row + yo) % world_row,(bugs->xpos + world_col + xo) % world_col,temp,1);
			break;
		case 2:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row + yo) % world_row,(bugs->xpos + world_col - xo) % world_col,temp,1);
			break;
		case 3:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row - yo) % world_row,(bugs->xpos + world_col - xo) % world_col,temp,1);
			break;
		default:
			fprintf(stderr,"default bugs->vector is bad\n");
			break;   
	}

	weight += motivate(temp[0],depth);
		
	if(is_pass(temp[0]))
	{
		if(depth < bugs->fov)
                        weight += look_b(depth+1,vec,yo+sin((vec+3)*M_PI_2),xo+sin((vec+0)*M_PI_2));
	
		if(depth < bugs->fov - 1)
		{
                        weight += look_b(depth+2,(vec+1)%4,yo+sin((vec+0)*M_PI_2),xo+cos((vec+1)*M_PI_2));
                        weight += look_b(depth+2,(vec+3)%4,yo+sin((vec+2)*M_PI_2),xo+cos((vec+3)*M_PI_2));
		}
	}
	return(weight);
}

int look(int search)
{
	char temp;
	float leftw = 0, rightw = 0, forwardw = 0;
	
	// look for mate and/or food
	
	temp = peek(1,0);
	if((temp == bugs->race)&&(bugs->food > MATE_LVL))
	{
		mate();
		// exausted ...
		return WAIT;
	} 
	
	if(temp == bugs->food_type)
	{
		placefood();  
		bugs->food += FOOD_VAL;
		return FORWARD;
	}

        forwardw = look_b(1,bugs->vector,sin((bugs->vector+3)*M_PI_2),cos((bugs->vector+3)*M_PI_2));
        rightw = look_b(2,(bugs->vector+1)%4,sin((bugs->vector+0)*M_PI_2),cos((bugs->vector+0)*M_PI_2));
        leftw = look_b(2,(bugs->vector+3)%4,sin((bugs->vector+2)*M_PI_2),cos((bugs->vector+2)*M_PI_2));
        forwardw -= look_b(3,(bugs->vector+2)%4,sin((bugs->vector+1)*M_PI_2),cos((bugs->vector+1)*M_PI_2));
	
	if((leftw > 0)||(rightw > 0)||(forwardw > 0))	
	{
		// forward > left & right
		if((forwardw > leftw)&&(forwardw > rightw))
	        {
	        	if((forwardw > 0)&&(is_pass(temp)))
        	        	return FORWARD;
	                else if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
        			return bugs->search[search];
        	        else
		       	       	return getrandom(LEFT,RIGHT);
		}
		// left > forward & right
		if((leftw > rightw)&&(leftw > forwardw))
	        {
	        	if(leftw > 0)
        	        	return LEFT;
	                else if(is_pass(temp))
        	        {
        	        	if((bugs->search[search] == RIGHT)||(bugs->search[search] == FORWARD))
        	        		return bugs->search[search];
				else
	        	        	return getrandom(RIGHT, FORWARD);
			}
			else
				return RIGHT;
		}
		// right > left & forward
		if((rightw > leftw)&&(rightw > forwardw))
	        {
	        	if(rightw > 0)
        	        	return RIGHT;
			else if (is_pass(temp))
			{
				if((bugs->search[search] == LEFT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return (getrandom(0,1) ? LEFT : FORWARD);
			}
			else 
				return LEFT;
		}	
		// left & right > forward
		if((leftw == rightw)&&(rightw > forwardw))
	        {
	        	if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
	        		return bugs->search[search];
	        	else
	        		return getrandom(LEFT,RIGHT);
		}
		// forward & right > left
		if((forwardw == rightw)&&(rightw > leftw))
                {
                	if(is_pass(temp))
			{
				if((bugs->search[search] == RIGHT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return getrandom(RIGHT,FORWARD);
			}
			else
				return RIGHT;
		}	
		// forward & left > right
		if((forwardw == leftw)&&(leftw > rightw))
                {
                	if(is_pass(temp))
			{
				if((bugs->search[search] == LEFT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return (getrandom(0,1) ? LEFT : FORWARD);
			}
			else
				return LEFT;
		}
		// all equil
        	if(is_pass(temp))
        	{
        		if(bugs->search[search] == WAIT)
        			return getrandom(LEFT, FORWARD);
        		else
        			return bugs->search[search];
		}
		else
		{
			if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
				return bugs->search[search];
			else
				return getrandom(LEFT, RIGHT);
		}
	}
	// default din't see anything good ...
        if((!is_pass(temp))&&(bugs->search[search] == FORWARD))
		return getrandom(WAIT, RIGHT);

	return bugs->search[search];
}

char peek(int fw, int lr)
{
	int val;
	char temp[3];
	
	switch(bugs->vector)
	{
		case 0:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row - fw) % world_row,(bugs->xpos + world_col + lr) % world_col,temp,1);
			break;
		case 1:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row + lr) % world_row,(bugs->xpos + world_col + fw) % world_col,temp,1);
			break;
		case 2:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row + fw) % world_row,(bugs->xpos + world_col - lr) % world_col,temp,1);
                        break;
		case 3:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row - lr) % world_row,(bugs->xpos + world_col - fw) % world_col,temp,1);
			break;
		default:
			fprintf(stderr,"default in peek bugs->vector is bad\n");
			break;   
	}
	return(temp[0]);
}
