#include <curses.h>
#include <math.h>
#include "bug4.h"

#define DIM 13

char stuff[DIM][DIM];

void c_stuff(void)
{
        int loop_1;
        int loop_2;
	
	for(loop_1 = 0; loop_1 < DIM; loop_1++)
                for(loop_2 = 0; loop_2 < DIM; loop_2++)
                        stuff[loop_2][loop_1] = '+';
	stuff[6][6] = 'x';
}

void p_stuff(void)
{
        int loop_1;
        int loop_2;
	
	if(bugs == sb)
	{
		for(loop_1 = 0; loop_1 < DIM; loop_1++)
        	{
                	for(loop_2 = 0; loop_2 < DIM; loop_2++)
                        	fprintf(stderr,"%c",stuff[loop_2][loop_1]);
			fprintf(stderr,"\n");
        	}
		c_stuff();
	}
}

int is_bug(char temp)
{
	if (temp >= L_RACE && temp <= H_RACE)
		return(1);
	else
		return(0);
}

int is_pass(char temp)
{
	if ((temp == WTR)||(temp == MNT)||(is_bug(temp)))
		return(0);
	else
		return(1);
}

float motivate(char temp, int depth)
{
	float motivation = 0;

	if ((temp == bugs->food_type)&&(bugs->food < MATE_LVL))
		motivation = (float)FOOD_VAL / (float)depth;

	else if ((temp == bugs->food_type)&&(bugs->food > MATE_LVL))
		motivation = (float)FOOD_VAL / (float)(depth * 2);

	else if ((temp == bugs->race)&&(bugs->food > MATE_LVL))
		motivation = (float)(bugs->food - MATE_LVL) / (float)depth;

	return(motivation);
}

// recursive fractal look ...
float look_b(int depth, int vec, int yo, int xo)
{
	float weight = 0;
	int val;
	char temp[3];
	
	switch(bugs->vector)
	{
		case 0:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row - yo) % world_row,(bugs->xpos + world_col + xo) % world_col,temp,1);
			//stuff[6+xo][6+yo] = temp[0];
			break;
		case 1:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row + yo) % world_row,(bugs->xpos + world_col + xo) % world_col,temp,1);
			//stuff[6+xo][6+yo] = temp[0];
			break;
		case 2:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row + yo) % world_row,(bugs->xpos + world_col - xo) % world_col,temp,1);
			//stuff[6+xo][6+yo] = temp[0];
			break;
		case 3:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row - yo) % world_row,(bugs->xpos + world_col - xo) % world_col,temp,1);
			//stuff[6+xo][6+yo] = temp[0];
			break;
		default:
			fprintf(stderr,"default bugs->vector is bad\n");
			break;   
	}

	weight += motivate(temp[0],depth);
		
	if(is_pass(temp[0]))
	{
		if(depth < bugs->fov)
		{
			switch(vec)
			{
				case(0):
					weight += look_b(depth+1,vec,yo-1,xo);
					break;
				case(1):
					weight += look_b(depth+1,vec,yo,xo+1);
					break;
				case(2):
					weight += look_b(depth+1,vec,yo+1,xo);
					break;
				case(3):
					weight += look_b(depth+1,vec,yo,xo-1);
					break;
				default:
					break;
			}
		}
	
		if(depth < bugs->fov - 1)
		{
			switch(vec)
			{
				case(0):
					weight += look_b(depth+2,(vec+1)%4,yo,xo+1);
					weight += look_b(depth+2,(vec+3)%4,yo,xo-1);
					break;
				case(1):
					weight += look_b(depth+2,(vec+1)%4,yo+1,xo);
					weight += look_b(depth+2,(vec+3)%4,yo-1,xo);
					break;
				case(2):
					weight += look_b(depth+2,(vec+1)%4,yo,xo-1);
					weight += look_b(depth+2,(vec+3)%4,yo,xo+1);
					break;
				case(3):
					weight += look_b(depth+2,(vec+1)%4,yo-1,xo);
					weight += look_b(depth+2,(vec+3)%4,yo+1,xo);
					break;
				default:
					break;
			}
		}
	}
	return(weight);
}

int look(int search)
{
	char temp;
	float leftw = 0, rightw = 0, forwardw = 0;
	
	// look for mate and/or food
	
	temp = peek(1,0);
	if((temp == bugs->race)&&(bugs->food > MATE_LVL))
	{
		mate();
		// exausted ...
		return WAIT;
	} 
	
	if(temp == bugs->food_type)
	{
		placefood();  
		bugs->food += FOOD_VAL;
		return FORWARD;
	}

	//c_stuff();
	switch(bugs->vector)
	{
		case(0):
			forwardw = look_b(1,bugs->vector,-1,0);
			//fprintf(stderr,"bv=0 forward\n");
			//p_stuff();
			rightw = look_b(2,(bugs->vector+1)%4,0,1);
			//fprintf(stderr,"bv=0 right\n");
			//p_stuff();
			leftw = look_b(2,(bugs->vector+3)%4,0,-1);
			//fprintf(stderr,"bv=0 left\n");
			//p_stuff();
			forwardw -= look_b(3,(bugs->vector+2)%4,1,0);
			//fprintf(stderr,"bv=0 back\n");
			//p_stuff();
			break;
		case(1):
			forwardw = look_b(1,bugs->vector,0,1);
			//fprintf(stderr,"bv=1 forward\n");
			//p_stuff();
			rightw = look_b(2,(bugs->vector+1)%4,1,0);
			//fprintf(stderr,"bv=1 right\n");
			//p_stuff();
			leftw = look_b(2,(bugs->vector+3)%4,-1,0);
			//fprintf(stderr,"bv=1 left\n");
			//p_stuff();
			forwardw -= look_b(3,(bugs->vector+2)%4,0,-1);
			//fprintf(stderr,"bv=1 back\n");
			//p_stuff();
			break;
		case(2):
			forwardw = look_b(1,bugs->vector,1,0);
			//fprintf(stderr,"bv=2 forward\n");
			//p_stuff();
			rightw = look_b(2,(bugs->vector+1)%4,0,-1);
			//fprintf(stderr,"bv=2 right\n");
			//p_stuff();
			leftw = look_b(2,(bugs->vector+3)%4,0,1);
			//fprintf(stderr,"bv=2 left\n");
			//p_stuff();
			forwardw -= look_b(3,(bugs->vector+2)%4,-1,0);
			//fprintf(stderr,"bv=2 back\n");
			//p_stuff();
			break;
		case(3):
			forwardw = look_b(1,bugs->vector,0,-1);
			//fprintf(stderr,"bv=3 forward\n");
			//p_stuff();
			rightw = look_b(2,(bugs->vector+1)%4,-1,0);
			//fprintf(stderr,"bv=3 right\n");
			//p_stuff();
			leftw = look_b(2,(bugs->vector+3)%4,1,0);
			//fprintf(stderr,"bv=3 left\n");
			//p_stuff();
			forwardw -= look_b(3,(bugs->vector+2)%4,0,1);
			//fprintf(stderr,"bv=3 back\n");
			//p_stuff();
			break;
		default:
			break;
	}				
	
	if((leftw > 0)||(rightw > 0)||(forwardw > 0))	
	{
		// forward > left & right
		if((forwardw > leftw)&&(forwardw > rightw))
	        {
	        	if((forwardw > 0)&&(is_pass(temp)))
        	        	return FORWARD;
	                else if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
        			return bugs->search[search];
        	        else
		       	       	return getrandom(LEFT,RIGHT);
		}
		// left > forward & right
		if((leftw > rightw)&&(leftw > forwardw))
	        {
	        	if(leftw > 0)
        	        	return LEFT;
	                else if(is_pass(temp))
        	        {
        	        	if((bugs->search[search] == RIGHT)||(bugs->search[search] == FORWARD))
        	        		return bugs->search[search];
				else
	        	        	return getrandom(RIGHT, FORWARD);
			}
			else
				return RIGHT;
		}
		// right > left & forward
		if((rightw > leftw)&&(rightw > forwardw))
	        {
	        	if(rightw > 0)
        	        	return RIGHT;
			else if (is_pass(temp))
			{
				if((bugs->search[search] == LEFT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return (getrandom(0,1) ? LEFT : FORWARD);
			}
			else 
				return LEFT;
		}	
		// left & right > forward
		if((leftw == rightw)&&(rightw > forwardw))
	        {
	        	if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
	        		return bugs->search[search];
	        	else
	        		return getrandom(LEFT,RIGHT);
		}
		// forward & right > left
		if((forwardw == rightw)&&(rightw > leftw))
                {
                	if(is_pass(temp))
			{
				if((bugs->search[search] == RIGHT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return getrandom(RIGHT,FORWARD);
			}
			else
				return RIGHT;
		}	
		// forward & left > right
		if((forwardw == leftw)&&(leftw > rightw))
                {
                	if(is_pass(temp))
			{
				if((bugs->search[search] == LEFT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return (getrandom(0,1) ? LEFT : FORWARD);
			}
			else
				return LEFT;
		}
		// all equil
        	if(is_pass(temp))
        	{
        		if(bugs->search[search] == WAIT)
        			return getrandom(LEFT, FORWARD);
        		else
        			return bugs->search[search];
		}
		else
		{
			if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
				return bugs->search[search];
			else
				return getrandom(LEFT, RIGHT);
		}
	}
	// default din't see anything good ...
        if((!is_pass(temp))&&(bugs->search[search] == FORWARD))
		return getrandom(WAIT, RIGHT);

	return bugs->search[search];
}

char peek(int fw, int lr)
{
	int val;
	char temp[3];
	
	switch(bugs->vector)
	{
		case 0:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row - fw) % world_row,(bugs->xpos + world_col + lr) % world_col,temp,1);
			break;
		case 1:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row + lr) % world_row,(bugs->xpos + world_col + fw) % world_col,temp,1);
			break;
		case 2:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row + fw) % world_row,(bugs->xpos + world_col - lr) % world_col,temp,1);
			break;
		case 3:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row - lr) % world_row,(bugs->xpos + world_col - fw) % world_col,temp,1);
			break;
		default:
			fprintf(stderr,"default in peek bugs->vector is bad\n");
			break;   
	}
	return(temp[0]);
}
