#include <curses.h>
#include "bug3.h"

// it seems there may be bugs in some libaries/compilers
// if you bugs repot "this bug is F*****" when DEBUG is 1
// try setting GLITCH to 1 
#define GLITCH 1

void die(struct bug *temp)
{
	population--;
	mvwprintw(world_pad, temp->ypos,temp->xpos,"%c",FOOD1);
	refresh();
	if(temp == bugs)
		bugs = bugs->prev;
	if(temp == first)
		first = first->prev;
	if(temp == sb)
		sb = sb->prev;
	if(temp == hg)
		hg = hg->prev;
	if(temp == lp)
		lp = lp->prev;
	if(temp == hp)
		hp = hp->prev;
	if(temp == old)
		old = old->prev;
	temp->prev->next = temp->next;
	temp->next->prev = temp->prev;
	if(bugs == bugs->next)
		stop();
	free(temp);
}

void mate(void)
{
	struct bug *temp;
	struct bug *mate;
	int loop2, val;
	char tempch[3];
	int distance = 1;
	int tmin, tmax;


	// where is the mate???
	if(bugs->food < INIT_FOOD * 4)
		switch(bugs->vector)
		{
			case 0:
				// screen up
				mate = findbug((bugs->ypos - 1 + world_row) % world_row,bugs->xpos);
				break;
			case 1:
				// screen right
				mate = findbug(bugs->ypos,(bugs->xpos + 1) % world_col);
				break;
			case 2:
				// screen down
				mate = findbug((bugs->ypos + 1) % world_row,bugs->xpos);
				break;
			case 3: 
				// screen left
				mate = findbug(bugs->ypos,(bugs->xpos - 1 + world_col) % world_col);
				break;                                          
			default:
				fprintf(stderr, "default in mate find bugs->vector is bad\n");
				break;
		}
	else
		mate = bugs;
	
	population++;
				
	temp = (struct bug *) malloc (sizeof(struct bug));
	
	// still a glitch here... old linux ???
	while(tempch[0] != SPACE)
	{
		temp->ypos = -1;
		temp->xpos = -1;

		tmin = (bugs->ypos + world_row - getrandom(1, distance)) % world_row;
		tmax = (bugs->ypos + getrandom(1, distance)) % world_row;
		while ((temp->ypos < 0)||(temp->ypos > world_row))
			temp->ypos = tmin < tmax ? getrandom(tmin, tmax) : getrandom(tmax, tmin);

		tmin = (bugs->xpos + world_col - getrandom(1, distance)) % world_col;
		tmax = (bugs->xpos + getrandom(1, distance)) % world_col;
		while ((temp->xpos < 0)||(temp->xpos > world_col))
			temp->xpos = tmin < tmax ? getrandom(tmin, tmax) : getrandom(tmax, tmin);

		val = mvwinnstr(world_pad,temp->ypos,temp->xpos,tempch,1);
		
		distance++;
	}
	// fix the glitch ???
	if (GLITCH)
	{
		temp->xpos %= world_col;
		temp->ypos %= world_row;
	}

	// new bug race and generation
	if (getrandom (1,100) <= XENOGENESIS)
	{
		temp->race = getrandom (LOW_RACE,HIGH_RACE);
		temp->generation = 0;
	}
	else
	{
		temp->race = bugs->race;
		temp->generation = bugs->generation + 1;
	}
	
	temp->vector = getrandom(0,3);
	temp->food = INIT_FOOD / 2;
	temp->predlvl = (bugs->predlvl + mate->predlvl) / 2;
	temp->age = 0;

	// size is average of parents'
	temp->size = (bugs->size + mate->size)/2; 
	// with some standard deviation thrown in
	temp->size += (-1 + getrandom (0,2)) * getrandom (0,(MAX_SIZE-temp->size<temp->size-MIN_SIZE)?(MAX_SIZE-temp->size+1):(temp->size-MIN_SIZE+1));
	if (temp->size < MIN_SIZE) temp->size = MIN_SIZE;
	if (temp->size > MAX_SIZE) temp->size = MAX_SIZE;

	for(loop2 = 0; loop2 <= S_LEN; loop2++)
	{
		switch(getrandom(0,8))
		{
			case 0:
			case 2:
			case 4:
			case 6: 
			case 8:
				// copy parent bugs
				temp->search[loop2] = bugs->search[loop2];      
				break;
			case 1:
			case 3:
			case 5:
				// copy parent mate
				temp->search[loop2] = mate->search[loop2];      
				break;
			case 7:
				// mutate
				temp->search[loop2] = getrandom(0,3);
				break;
			default:
				fprintf(stderr, "default in new genes ...\n");
				break;
		}
		if (temp->search[loop2] == 0)
			temp->predlvl--;
		if (temp->search[loop2] == 3)
			temp->predlvl++;
	}

	if (temp->predlvl > BUG_PRED)
		temp->food_type = '\0';
	else
		temp->food_type = FOOD3;

	temp->next = bugs->next;
	bugs->next->prev = temp;
	bugs->next = temp;
	temp->prev = bugs;
	bugs->food -= MATE_COST * bugs->size;
	return;
}
