#include <curses.h>
#include "bug2.h"

void stat(void)
{
	struct bug *tempbug = bugs;
	struct counts all, pred;
	struct counts races[1 + (HIGH_RACE - LOW_RACE)];
	int temp;
	
	init_counts(&all);	
	init_counts(&pred);	
	for(temp = 0;temp <= HIGH_RACE - LOW_RACE;temp++)
		init_counts(&races[temp]);
	
	while(all.pop < population)
	{
		all.age += tempbug->age;
		all.food += tempbug->food;
		all.gen += tempbug->generation;
		if(tempbug->race == PREDITOR)
		{
			pred.pop++;
			pred.age += tempbug->age;
			pred.food += tempbug->food;
			pred.gen += tempbug->generation;	
		}
		else
		{
			races[HIGH_RACE - tempbug->race].pop++;
			races[HIGH_RACE - tempbug->race].age += tempbug->age;
			races[HIGH_RACE - tempbug->race].food += tempbug->food;
			races[HIGH_RACE - tempbug->race].gen += tempbug->generation;	
		}
		tempbug = tempbug->next;
		all.pop++;
	}	
	
	all.age /= all.pop;
	all.food /= all.pop;
	all.gen /= all.pop;
	
	if(pred.pop != 0)
	{
		pred.age /= pred.pop;
		pred.food /= pred.pop;
		pred.gen /= pred.pop;
	}
	
	for(temp = 0;temp <= HIGH_RACE - LOW_RACE;temp++)
		if(races[temp].pop != 0)	
		{
			races[temp].age /= races[temp].pop;
			races[temp].food /= races[temp].pop;
			races[temp].gen /= races[temp].pop;
		}
	
	fprintf(stderr,"Status ---------------------------------\n");
	fprintf(stderr,"race	pop	age	food	gen	\n");
	fprintf(stderr,"all	%i	%i	%i	%i	\n",all.pop,all.age,all.food,all.gen);
	if(pred.pop != 0)
		fprintf(stderr,"%c	%i	%i	%i	%i	\n",PREDITOR,pred.pop,pred.age,pred.food,pred.gen);
	for(temp = 0;temp <= HIGH_RACE - LOW_RACE;temp++)
		if(races[temp].pop != 0)
			fprintf(stderr,"%c	%i	%i	%i	%i	\n",HIGH_RACE - temp,races[temp].pop,races[temp].age,races[temp].food,races[temp].gen);

	return;
}

void init_counts (struct counts *temp)
{
	temp->pop = 0;
	temp->age = 0;
	temp->food = 0;
	temp->gen = 0;
	
	return;
}