#include <term.h>
#include <curses.h>
#include "bug2.h"

void init(void)
{
	initscr();
	init_kb();
	srand((unsigned) time ( NULL ));
	clear();
	start();
}

void start(void)
{
	struct bug *temp, *x;
	int loop, loop2;

	// place blocks ..
	attron(A_DIM);
	for(loop = 1; loop <= NUM_BLOCKS; loop++)
		mvprintw(getrandom(0,LINES-2),getrandom(0,COLS-1),"%c",BLOCK);
	attroff(A_DIM);
	
	// place food
	for(loop = 1; loop <= NUM_FOOD; loop++)
		placefood();
	refresh();
	
	// create bugs
	for(loop = 1; loop <= NUM_BUGS; loop++)
	{
		population++;
		temp = (struct bug *) malloc (sizeof(struct bug));
		temp->xpos = getrandom(0,COLS-1);
		temp->ypos = getrandom(0,LINES-2);
		temp->vector = getrandom(0,3);
		temp->food = INIT_FOOD;
		temp->food_type = FOOD3;
		temp->race = (char) getrandom(LOW_RACE,HIGH_RACE);
		temp->generation = 1;
		temp->age = 0;
		for(loop2 = 0; loop2 <= S_LEN; loop2++)
			temp->search[loop2] = getrandom(0,3);
		if(loop == 1)
			bugs = temp;
		else
		{
			x->next = temp;
			temp->prev = x;
		}
		x = temp;
	}
	temp->next = bugs;
	bugs->prev = temp;
	return;
}

void stop(void)
{
	close_kb();
	endwin();
	exit(0);
}
