#include <term.h>
#include <curses.h>
#include "bug2.h"
#include "kb.h"
#include "popup.h"

int main()
{
	int temp;
	int ch = 0;
	int search = 0;
	char *sbis = "xx \0";
	WINDOW *stat_bar;
	int pad_col = 0;
	int pad_row = 0;
	char msg[25];

	init();
	stat_bar = newwin(1, COLS, LINES-1, 0);

	cpuwait = 1;
	first = bugs;
	sb = bugs;
	hf = bugs;
	hg = bugs;
	old = bugs;
	
	while(1)
	{
		if(bugs == first)
		{
			// be nice to the processor
			usleep(cpuwait);

			// refresh the display
			prefresh(world_pad,pad_row,pad_col,0,0,LINES-2,COLS-1);
			wrefresh(stat_bar);
			
			// next "gene"
			search = ++search % S_LEN;

			// user did what ???
			if(kb_hit())
				ch = read_kb();
						
			switch(ch)
			{
				case 'c':
				case 'C':
					sprintf(msg,"pop = %i", population);
					dopopup(msg, 1);
					ch = '\0';
					break;
				case 'd':
				case 'D':
					for(temp = 0; temp < S_LEN; temp++)
						sprintf(&msg[temp],"%i",sb->search[temp]);
					dopopup(msg, 5);
					ch = '\0';
					break;
				case 'v':
				case 'V':
					sprintf(msg,"x=%i  y=%i", sb->xpos, sb->ypos);
					dopopup(msg, 2);
					ch = '\0';
					break;
				case '1':
					sbis = "xx \0";
					sb = sb->next;
					ch = '\0';
					break;
				case '2':
					sbis = "hf \0";
					sb = hf;
					break;
				case '3':
					sbis = "hg \0";
					sb = hg;
					break;
				case '4':
					sbis = "old\0";
					sb = old;
					break;
				case 'g':
				case 'G':
					pad_row = sb->ypos - ((LINES - 1) / 2);
					if (pad_row < 0)
						pad_row = 0;
					if (pad_row > (world_row - LINES + 1))
						pad_row = world_row - LINES + 1;
					pad_col = sb->xpos - (COLS / 2);
					if (pad_col < 0)
						pad_col = 0;
					if(pad_col > (world_col - COLS))
						pad_col = world_col - COLS;
					ch = '\0';
					break;
				case 'h':
				case 'H':
					if (pad_col > 0)
						pad_col--;
					ch = '\0';
					break;
				case 'j':
				case 'J':
					if (pad_row < (world_row - LINES + 1))
						pad_row++;
					ch = '\0';
					break;
				case 'k':
				case 'K':
					if (pad_row > 0)	
						pad_row--;
					ch = '\0';
					break;
				case 'l':
				case 'L':
					if (pad_col < (world_col - COLS))
						pad_col++;
					ch = '\0';
					break;
				case 'x':
				case 'X':
					stop();
					break;
				case 'f':
				case 'F':
					if(cpuwait <= 1)
						cpuwait = 0;
					else
						cpuwait /= 2;
					sprintf(msg,"speed=%i", cpuwait);
					dopopup(msg, 1);
					ch = '\0';
					break;
				case 's':
				case 'S':
					if(cpuwait == 0)
						cpuwait = 1;
					else
						cpuwait *= 2;
					sprintf(msg,"speed=%i", cpuwait);
					dopopup(msg, 1);
					ch = '\0';
					break;				
				case 't':
				case 'T':
					cpuwait = 0;
					sprintf(msg,"speed=%i", cpuwait);
					dopopup(msg, 1);
					ch = '\0';
					break;
				case 'p':
				case 'P':
					dopopup("Pause", 1);
				case 'n':
				case 'N':
					ch = '\0';
					while(((ch != 'p')&&(ch != 'P'))&&((ch != 'n')&&(ch != 'N')))
					{
						usleep(10000);
						prefresh(world_pad,pad_row,pad_col,0,0,LINES-2,COLS-1);
						wrefresh(stat_bar);
										
						if(kb_hit())
							ch = read_kb();
						else
							ch = '\0';

						attron(A_BOLD);
						mvprintw(sb->ypos,sb->xpos,"%c",sb->race);
						attroff(A_BOLD);

						switch(ch)
						{
							case 'd':
							case 'D':
								for(temp = 0; temp < S_LEN; temp++)
									sprintf(&msg[temp],"%i",sb->search[temp]);
								dopopup(msg, 5);
								ch = '\0';
								break;
							case 'c':
							case 'C':
								sprintf(msg,"pop = %i", population);
								dopopup(msg, 1);
								break;
							case 'v':
							case 'V':
								sprintf(msg,"x=%i  y=%i", sb->xpos, sb->ypos);
								dopopup(msg, 2);
								break;
							case 'h':
							case 'H':
								if (pad_col > 0)
									pad_col--;
								break;
							case 'j':
							case 'J':
								if (pad_row < (world_row - LINES + 1))
									pad_row++;
								break;
							case 'k':
							case 'K':
								if (pad_row > 0)	
									pad_row--;
								break;
							case 'l':
							case 'L':
								if (pad_col < (world_col - COLS))
									pad_col++;
								break;
							case 'g':
							case 'G':
								pad_row = sb->ypos - ((LINES - 1) / 2);
								if (pad_row < 0)
									pad_row = 0;
								if (pad_row > (world_row - LINES + 1))
									pad_row = world_row - LINES + 1;
								pad_col = sb->xpos - (COLS / 2);
								if (pad_col < 0)
									pad_col = 0;
								if(pad_col > (world_col - COLS))
									pad_col = world_col - COLS;
								break;
							case '1':
								sbis = "xx \0";
								sb = sb->next;
								break;
							case '2':
								sbis = "hf \0";
								sb = hf;
								break;
							case '3':
								sbis = "hg \0";
								sb = hg;
								break;
							case '4':
								sbis = "old\0";
								sb = old;
								break;
							case 'x':
							case 'X':
								stop();
								break;
							case 's':
							case 'S':
							case 'f':
							case 'F':
								ch = 'p';
								break;
							case 't':
							case 'T':
								cpuwait = 0;
								sprintf(msg,"speed=%i", cpuwait);
								dopopup(msg, 1);
								ch = 'p';
								break;
							default:
								// any other key ...
								break;
						}
						// show status bar
						mvwprintw(stat_bar, 0, 0, "x 1234vd ghjkl fstpnc  %s %c %i %i %i",sbis,sb->race,sb->generation,sb->food,sb->age);
					}
					if((ch != 'n')&&(ch != 'N'))
						ch = '\0';
					break;
				default:
					// user hit unused key
					break;
			}
				
			// show status bar
			mvwprintw(stat_bar, 0, 0, "x 1234vd ghjkl fstpnc  %s %c %i %i %i",sbis,sb->race,sb->generation,sb->food,sb->age);
		}
		if(search == 0)
		{
			// get older
			bugs->age++;
			
			// did i starve to death ???
			if(--bugs->food <= 0)
			{
				if(DEBUG)
					fprintf(stderr,"strave\n");
				die(bugs);
			}
			
			if(bugs->food >= INIT_FOOD * 4)
			{
				mate();
				bugs->food /= 5;
			}
			// grow some food
			if(bugs == first)
			{
				growfood();
				if(STAT)
					stat();
			}
		}

		if (bugs->food > hf->food)
			hf = bugs;

		if (bugs->generation > hg->generation)
			hg = bugs;

		if (bugs->age > old->age)
			old = bugs;
			
		bugs = bugs->next;
		mvwprintw(world_pad, bugs->ypos,bugs->xpos," ");

		// what am i doing???
		switch(look(search))
		{
			case WAIT:
				// do nothing
				break;
			case LEFT:
				// turn left
				bugs->vector = (--bugs->vector + 4) % 4;        
				break;
			case RIGHT:
				// turn right
				bugs->vector = ++bugs->vector % 4;
				break;
			case FORWARD:
				// move ahead
				switch(bugs->vector)
				{
					case 0:
						// screen up
						bugs->ypos = (--bugs->ypos + world_row) % world_row;
						break;
					case 1:
						// screen right
						bugs->xpos = (++bugs->xpos) % world_col;
						break;
					case 2:
						//screen down
						bugs->ypos = (++bugs->ypos) % world_row;
						break;
					case 3: 
						// screen left
						bugs->xpos = (--bugs->xpos + world_col) % world_col;
						break;                                          
					default:
						fprintf(stderr, "default in main inner bugs->vector is bad\n");
						break;
				}
				break;
			default:
				fprintf(stderr, "default in main look returned a bad value\n");
				break;
		}
		if(bugs == sb)
			attron(A_BOLD);
		mvwprintw(world_pad, bugs->ypos,bugs->xpos,"%c",bugs->race);
		if(bugs == sb)
			attroff(A_BOLD);
	}
	// exit from while loop ... should never happen
	fprintf(stderr,"exited from main while loop this is bad ...\n");
	stop();
}
