/*
 * Copyright James Morse Y2K+1
 * This is GPLed software 
 * please read COPYING
 *
 * (large) portions contributed by John Campbell 
 * www.ci-n.com/~jcampbel
 *
 */

#include <math.h>
#include "big.h"
#include "terrain.h"

void generateterrain (int grid_size, int roughness)
{
	int elevation_map[world_col][world_row];
	int x, y;
	int grid_s = pow (2, grid_size);

	/* define primary grid */
	for (x = 0; x < world_col; x += grid_s) 
	{
		for (y = 0; y < world_row; y += grid_s) 
		{
			elevation_map[x][y] = getrandom (0, HEIGHT);
		}
	}

	for (grid_s /= 2; grid_s >= 1; grid_s /= 2) 
	{	
		/* interpolate smaller grid along horizontals */
		for (x = grid_s; x < world_col; x += grid_s * 2) 
		{
			for (y = 0; y < world_row; y += grid_s * 2) 
			{
				elevation_map[x][y] = getrandom (-roughness * log10 (grid_s), roughness * log10 (grid_s)) + (elevation_map[x - grid_s][y] + elevation_map[(x + grid_s < world_col) ? (x + grid_s) : (0)][y]) / 2;
			}
		}
		
		/* interpolate smaller grid along verticals */
		for (x = 0; x < world_col; x += grid_s * 2) 
		{
			for (y = grid_s; y < world_row; y += grid_s * 2) 
			{
				elevation_map[x][y] = getrandom (-roughness * log10 (grid_s), roughness * log10 (grid_s)) + (elevation_map[x][y - grid_s] + elevation_map[x][(y + grid_s < world_row) ? (y + grid_s) : (0)]) / 2;
			}
		}
		
		/* interpolate smaller grid between gridlines */
		for (x = grid_s; x < world_col; x += grid_s * 2) 
		{
			for (y = grid_s; y < world_row; y += grid_s * 2) 
			{
				elevation_map[x][y] = getrandom (-roughness * log10 (grid_s), roughness * log10 (grid_s)) + (elevation_map[x][y - grid_s] + elevation_map[x][(y + grid_s < world_row) ? (y + grid_s) : (0)] + elevation_map[(x + grid_s < world_col) ? (x + grid_s) : (0)][y] + elevation_map[x - grid_s][y]) / 4;
			}
		}
	}

	/* place WTR's and MNT's */
	for (x = 0; x < world_col; x++) 
	{
		for (y = 0; y < world_row; y++) 
		{
			if (elevation_map[x][y] <= WTR_LVL) 
				world[world_col * y + x] = WTR;
			
			else if (elevation_map[x][y] >= MNT_LVL) 
				world[world_col * y + x] = MNT;
			else
				world[world_col * y + x] = SPC;
		}
	}

	return;
}
