/*
 * Copyright James Morse Y2K+1
 * This is GPLed software 
 * please read COPYING
 *
 */

#include <unistd.h>
#include <termios.h>
#include "kb.h"

void init_kb ()
{
	tcgetattr (0, &init_setting);
	new_setting = init_setting;
	new_setting.c_lflag &= -ICANON;
	new_setting.c_lflag &= -ECHO;
	new_setting.c_lflag &= -ISIG;
	new_setting.c_cc[VMIN] = 1;
	new_setting.c_cc[VTIME] = 0;
	tcsetattr(0, TCSANOW, &new_setting);
}

void close_kb ()
{
	tcsetattr (0, TCSANOW, &init_setting);
}

int kb_hit ()
{
	char ch;
	int nread;

	if (peek_char != -1)
		return 1;
	
	new_setting.c_cc[VMIN] = 0;
	tcsetattr (0, TCSANOW, &new_setting);
	nread = read (0, &ch, 1);
	new_setting.c_cc[VMIN] = 1;
	tcsetattr (0, TCSANOW, &new_setting);
	
	if (nread == 1)
	{
		peek_char = ch;
		return 1;
	}
	return 0;
}

int read_kb ()
{
	char ch;
	
	if (peek_char != -1)
	{
		ch = peek_char;
		peek_char = -1;
		return ch;
	}
	read (0, &ch, 1);
	return 0;
}
