/*
 *  Copyright James Morse Y2K+1   please read COPYING
 *
 *  Questions and comments may be sent to: xbeastx@writeme.com 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the 
 *
 *  Free Software Foundation, Inc.
 *  59 Temple Place, Suite 330
 *  Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <termios.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include "big.h"
#include "kb.h"
#include "gpl.h"
#include "food.h"

int main(int argc, char *argv[])
{
	int tmpr = 0, tmpc = 0;
	char sd = 'l';
	int temp;
	int grid_size = 4;
	int roughness = 100;

	/* default world size to phyical screen */
	world_row = RROW - 5;
	world_col = RCOL;
		
	/* parse cammand line */
	if (argc > 1)
	{
		for (temp = 1; temp < argc; temp++)
		{
			/* set world size */
			if (strcmp (argv[temp], "-s") == 0)
			{
				world_row = atoi (argv[++temp]);
				world_col = atoi (argv[++temp]);
				if (!world_row || !world_col)
				{
					fprintf (stderr, "try -s [rows cols]\n");
					exit (1);
				}
			}

			/* set roughness */
			else if (strcmp (argv[temp], "-r") == 0)
			{
				roughness = atoi (argv[++temp]);
				if ((roughness < 1) || (roughness > 1000))
				{
					fprintf (stderr, "try -r [1-1000]\n");
					exit (2);
				}
			}

			/* set grid size */
			else if (strcmp (argv[temp], "-g") == 0)
			{
				grid_size = atoi (argv[++temp]);
				if ((grid_size < 2) || (grid_size > 8))
				{
					fprintf (stderr, "try -g [2-8]\n");
					exit (3);
				}
			}

			/* display licnse */
			else if (strcmp (argv[temp], "-l") == 0)
			{
				gnu();
				exit(0);
			}

			/* bad user ... */
			else 
			{
				fprintf (stderr, "bad args\n");
				exit (3);
			}
		}
	}
	
	/* setup some stuff */

	/* make the world */
	if ((world = (char *)malloc(world_row * world_col)) == NULL)
	{
		printf("bad malloc ... no world!!!\n");
		exit(4);
	}

	/* seed the random number generator */
	srand ((unsigned) time ( NULL ));

	/* generate the terrain */
	generateterrain (grid_size, roughness);

	/* initalize the keyboard */
	init_kb();

	/* clear the screen */
	printf("%c[2J", 033);

	/* place food */
	for (temp = 0 ; temp < 10 ; temp++)
		placefood();
	
	/* main loop */
	for (;;)
	{
		/* did the user do something? */
		if (kb_hit())
			sd = read_kb();
			
		/* what are doing? */
		switch (sd)
		{
			case '\0': /* do nothing */
				break;
			case 'h': /* left to right */
				if (--tmpc < 0)
					tmpc = world_col;
				break;
			case 'j': /* bottom to top */
				if (++tmpr > world_row)
					tmpr = 0;
				break;
			case 'k': /* top to bottom */
				if (--tmpr < 0)
					tmpr = world_row;
				break;
			case 'l': /* right to left */
				if (++tmpc > world_col)
					tmpc = 0;
				break;
			case 'x': /* exit */
				stop(0);
				break;
			default: /* bad user ... */
				printf("bad key");
				break;
		}

		/* grow food */
		growfood();
		
		/* show this frame */
		display(tmpr, tmpc);
	//	sleep(1);
		sd = '\0';
	}
	
	/* ooops ... */
	printf("we should never exit this way\n");
	stop(254);
	/* and evan if we do, we never get here */
	return(255);
}

/* safe stop */
void stop(int ec)
{
	/* restore keyborad */
	close_kb();
	
	exit(ec);
}
